(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     28092,        792]
NotebookOptionsPosition[     25741,        718]
NotebookOutlinePosition[     26092,        733]
CellTagsIndexPosition[     26049,        730]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Buchroeder Camera", "Title"],

Cell[CellGroupData[{

Cell["Main function", "Subsection"],

Cell[TextData[StyleBox["BuchroederCamera",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["f1",
           FontWeight->Bold], Cell["focal length of the primary mirror"]},
         {Cell["spes",
           FontWeight->Bold], Cell["list of thickness of the lenses"]},
         {Cell["diam",
           FontWeight->Bold], Cell["diameter of the primary mirror"]},
         {Cell["Ni",
           FontWeight->Bold], Cell["refractive index of the lens"]},
         {Cell["\[Theta]",
           FontWeight->Bold], Cell["field angle in degrees"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interface function", "Subsection"],

Cell[TextData[{
 StyleBox["BuchroederCameraInputPanel",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 " (no argument required, it creates a panel to work with the main function \
by means of easy controls and input fields)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary function", "Subsection"],

Cell[TextData[StyleBox["TotalAberrations",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Analysis of a Buchroeder Camera", "Title"],

Cell["\<\
The corrector is formed by three thin lenses placed at the center of \
curvature of the primary mirror. Consequently, the camera is as long as the \
corresponding Schmidt's camera. The three lenses are made by the same glass, \
for instance, by BK7. Moreover, the radii of curvature of the surfaces of the \
lenses verify the conditions:\
\>", "Text",
 CellChangeTimes->{{3.425523537234375*^9, 3.425523576859375*^9}, {
   3.437483082546875*^9, 3.437483104140625*^9}, 3.4374831393125*^9, {
   3.43865891740625*^9, 3.43865901709375*^9}, {3.4386595325625*^9, 
   3.438659554125*^9}, {3.43865960203125*^9, 3.438659610765625*^9}, {
   3.43892839534375*^9, 3.438928408390625*^9}, {3.6659910502525268`*^9, 
   3.665991058033538*^9}, 3.66600698046875*^9, {3.666007024703125*^9, 
   3.666007041890625*^9}, {3.677242637640063*^9, 3.677242658890093*^9}, {
   3.6772525563095636`*^9, 3.6772525759937067`*^9}}],

Cell["\<\
Therefore, only the radius of curvature R1 is free and it is chosen to \
eliminate the spherical aberration. The corrector is afocal and the \
astigmatism and coma vanish when the lenses have no thickness. \
\>", "Text",
 CellChangeTimes->{{3.425523537234375*^9, 3.425523576859375*^9}, {
   3.437483082546875*^9, 3.437483104140625*^9}, 3.4374831393125*^9, {
   3.43865891740625*^9, 3.43865901709375*^9}, {3.4386595325625*^9, 
   3.438659554125*^9}, {3.43865960203125*^9, 3.438659610765625*^9}, {
   3.43892839534375*^9, 3.438928408390625*^9}, {3.6659910502525268`*^9, 
   3.665991058033538*^9}, 3.66600698046875*^9, {3.666007024703125*^9, 
   3.666007041890625*^9}, {3.677242637640063*^9, 3.677242658890093*^9}, {
   3.6772525563095636`*^9, 3.677252593521841*^9}}],

Cell[TextData[StyleBox["In order to find the aberration coefficients of the \
corrector, that is afocal, we evaluate its spherical aberration coefficients. \
(the variables c1, Ni, r, x, \[Theta], \[Lambda] have to be unassigned, for \
that we use Clear)",
 FontSize->18]], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "c1", ",", " ", "Ni", ",", " ", "r", ",", " ", "x", ",", " ", "\[Theta]", 
    ",", " ", "\[Lambda]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rad", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "c1"}], ",", "Infinity", ",", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "c1"}], ",", 
      RowBox[{"1", "/", "c1"}], ",", "Infinity", ",", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "c1"}]}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "Ni", ",", "1", ",", "Ni", ",", "1", ",", "Ni", ",", "1"}], 
      "}"}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "r", ",", "0", ",", 
   "0", ",", 
   RowBox[{"-", "Infinity"}], ",", "x", ",", "\[Theta]", ",", 
   RowBox[{"{", "\[Lambda]", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.42552361134375*^9, 3.425523633953125*^9}, {
   3.425523670265625*^9, 3.425523712671875*^9}, 3.425524065125*^9, 
   3.43748320403125*^9, 3.438659758078125*^9, {3.677242677030118*^9, 
   3.6772426771901183`*^9}, 3.67725327847869*^9}],

Cell["\<\
The spherical coefficient is given by the first value of the variable \
GOSphericalCoefficient generated by TotalAberration\
\>", "Text",
 CellChangeTimes->{{3.677253401725638*^9, 3.6772534087446966`*^9}, {
  3.6772535414646635`*^9, 3.677253571684866*^9}}],

Cell[BoxData[
 RowBox[{"GOSphericalCoefficient", "//", "Simplify"}]], "Input"],

Cell["\<\
The coma coefficient is given by the first value of the variable \
GOComaCoefficient \
\>", "Text",
 CellChangeTimes->{{3.6772535938520136`*^9, 3.677253620393217*^9}}],

Cell[BoxData[
 RowBox[{"GOComaCoefficient", "//", "Simplify"}]], "Input"],

Cell["\<\
The astigmatism coefficient is given by the first value of the variable \
GOAstigmatismCoefficient \
\>", "Text",
 CellChangeTimes->{{3.6772535938520136`*^9, 3.677253620393217*^9}, {
  3.677253692883747*^9, 3.6772537055628242`*^9}}],

Cell[BoxData[
 RowBox[{"GOAstigmatismCoefficient", "//", "Simplify"}]], "Input"],

Cell[TextData[StyleBox["Then, the spherical coefficient of the corrector is",
 FontSize->18]], "Text",
 CellChangeTimes->{{3.4255237369375*^9, 3.4255237823125*^9}, {3.4374836805*^9,
   3.43748376421875*^9}, {3.437483936140625*^9, 3.43748402825*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DS1", "=", 
    FractionBox[
     RowBox[{
      SuperscriptBox["c1", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "Ni"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "Ni"}], ")"}]}], 
     RowBox[{"2", " ", "Ni"}]]}], ";"}], "\n"}]], "Input"],

Cell[TextData[StyleBox["To balance the spherical aberration of the corrector \
with the spherical aberration of the primary mirror, we must solve the \
equation",
 FontSize->18]], "Text",
 CellChangeTimes->{{3.4255237369375*^9, 3.4255237823125*^9}, {
  3.4255243268125*^9, 3.425524350390625*^9}, {3.43748350165625*^9, 
  3.437483517328125*^9}, {3.437484045484375*^9, 3.437484053953125*^9}, {
  3.438661021453125*^9, 3.43866104559375*^9}}],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"DS1", "-", 
      FractionBox["1", 
       RowBox[{"32", 
        SuperscriptBox["f", "3"]}]]}], "\[Equal]", "0"}], ",", "c1"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.43866076815625*^9, 3.43866076990625*^9}}],

Cell[TextData[StyleBox["Only the second root is real.",
 FontSize->18]], "Text",
 CellChangeTimes->{{3.4255237369375*^9, 3.4255237823125*^9}, {
   3.4255243268125*^9, 3.425524350390625*^9}, {3.425524453796875*^9, 
   3.425524460109375*^9}, {3.43748355309375*^9, 3.4374835885625*^9}, 
   3.438660954609375*^9, 3.43866114578125*^9, 3.677242694080142*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["BuchroederCamera Examples", "Title"],

Cell["\<\
To use the BuchroederCamera function you can either use directly the function \
BuchroederCamera[f1, spes, diam, Ni, \[Theta]] or use the interactive panel \
created by calling the function BuchroederCameraInputPanel[]. It let\
\[CloseCurlyQuote]s you to set input values and then call the \
BuchroederCamera function. Moreover, it helps to load examples from the saved \
archives and set the output style.
Here are some examples\
\>", "Text"],

Cell["Buchroeder Camera with primary mirror F/3", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spes", "=", 
   RowBox[{"{", 
    RowBox[{"10", ",", "6", ",", "6", ",", "6", ",", "10"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ni", "=", "1.5168"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "1.5"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"BuchroederCamera", "[", 
  RowBox[{"f1", ",", "spes", ",", "diam", ",", "Ni", ",", "\[Theta]"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "generates", " ", "a", " ", "new", " ", "notebook", " ", 
    "with", " ", "a", " ", "report", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"BuchroederCamera", "[", 
   RowBox[{"f1", ",", "spes", ",", "diam", ",", "Ni", ",", "\[Theta]"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "the", 
    " ", "summary", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"BuchroederCamera", "[", 
   RowBox[{
   "f1", ",", "spes", ",", "diam", ",", "Ni", ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "only", 
    " ", "the", " ", "output", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"BuchroederCamera", "[", 
   RowBox[{
   "f1", ",", "spes", ",", "diam", ",", "Ni", ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"this", " ", "gives", " ", 
     RowBox[{"input", "/", "output"}], " ", "values", " ", "as", " ", "a", 
     " ", "Return", " ", "from", " ", "the", " ", "function"}], ",", " ", 
    RowBox[{
    "with", " ", "labels", " ", "for", " ", "each", " ", "variable"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"BuchroederCamera", "[", 
   RowBox[{
   "f1", ",", "spes", ",", "diam", ",", "Ni", ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Basic\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Full\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "this", " ", "gives", " ", "only", " ", "output", " ", "values", " ", 
     "as", " ", "a", " ", "Return", " ", "from", " ", "the", " ", 
     "function"}], ",", " ", 
    RowBox[{"with", " ", "no", " ", "labels", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"useful", " ", "for", " ", "cutting"}], "&"}], "pasting", " ",
        "operations"}], " "}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"BuchroederCamera", "[", 
   RowBox[{
   "f1", ",", "spes", ",", "diam", ",", "Ni", ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Values\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell["Buchroeder Camera with primary mirror F/2.5.", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spes", "=", 
   RowBox[{"{", 
    RowBox[{"12", ",", "8", ",", "6", ",", "8", ",", "12"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ni", "=", "1.5168"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "2"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"BuchroederCamera", "[", 
  RowBox[{"f1", ",", "spes", ",", "diam", ",", "Ni", ",", "\[Theta]"}], 
  "]"}]], "Input"],

Cell["Buchroeder Camera with primary mirror F/2.", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "400"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spes", "=", 
   RowBox[{"{", 
    RowBox[{"12", ",", "7", ",", "6", ",", "7", ",", "12"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ni", "=", "1.5168"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "2.5"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"BuchroederCamera", "[", 
  RowBox[{"f1", ",", "spes", ",", "diam", ",", "Ni", ",", "\[Theta]"}], 
  "]"}]], "Input"],

Cell["Load examples from the archive using LoadExample ", "Text"],

Cell[BoxData[
 RowBox[{"LoadExample", "[", "\"\<BuchroederCamera\>\"", "]"}]], "Input",
 CellChangeTimes->{3.677252785520843*^9}],

Cell[BoxData[
 RowBox[{"BuchroederCamera", "[", "]"}]], "Input",
 CellChangeTimes->{3.6772527880128546`*^9}],

Cell["Use the GUI panel to have all parameters under control", "Text"],

Cell[BoxData[
 RowBox[{"BuchroederCameraInputPanel", "[", "]"}]], "Input",
 CellChangeTimes->{3.6772527986159506`*^9}]
}, Open  ]]
},
WindowSize->{1920, 992},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"GeometricOptics.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 34, 0, 71, "Title"],
Cell[CellGroupData[{
Cell[638, 26, 35, 0, 43, "Subsection"],
Cell[676, 28, 111, 2, 46, "Text"],
Cell[790, 32, 1525, 40, 261, "Text"],
Cell[2318, 74, 2110, 53, 389, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4465, 132, 40, 0, 43, "Subsection"],
Cell[4508, 134, 252, 6, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4797, 145, 40, 0, 43, "Subsection"],
Cell[4840, 147, 111, 2, 46, "Text"],
Cell[4954, 151, 3193, 83, 551, "Text"],
Cell[8150, 236, 2296, 56, 473, "Text"],
Cell[10449, 294, 3162, 83, 723, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13660, 383, 48, 0, 71, "Title"],
Cell[13711, 385, 907, 14, 70, "Text"],
Cell[14621, 401, 774, 12, 46, "Text"],
Cell[15398, 415, 281, 4, 46, "Text"],
Cell[15682, 421, 1048, 34, 121, "Input"],
Cell[16733, 457, 522, 10, 32, "Input"],
Cell[17258, 469, 266, 5, 46, "Text"],
Cell[17527, 476, 78, 1, 32, "Input"],
Cell[17608, 479, 177, 4, 46, "Text"],
Cell[17788, 485, 73, 1, 32, "Input"],
Cell[17864, 488, 242, 5, 46, "Text"],
Cell[18109, 495, 80, 1, 32, "Input"],
Cell[18192, 498, 249, 3, 46, "Text"],
Cell[18444, 503, 371, 13, 77, "Input"],
Cell[18818, 518, 438, 7, 46, "Text"],
Cell[19259, 527, 315, 10, 51, "Input"],
Cell[19577, 539, 352, 5, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19966, 549, 42, 0, 71, "Title"],
Cell[20011, 551, 453, 8, 94, "Text"],
Cell[20467, 561, 57, 0, 46, "Text"],
Cell[20527, 563, 451, 13, 121, "Input"],
Cell[20981, 578, 140, 3, 32, "Input"],
Cell[21124, 583, 412, 10, 55, "Input"],
Cell[21539, 595, 464, 11, 55, "Input"],
Cell[22006, 608, 491, 11, 55, "Input"],
Cell[22500, 621, 641, 14, 55, "Input"],
Cell[23144, 637, 760, 18, 55, "Input"],
Cell[23907, 657, 60, 0, 46, "Text"],
Cell[23970, 659, 449, 13, 121, "Input"],
Cell[24422, 674, 140, 3, 32, "Input"],
Cell[24565, 679, 58, 0, 46, "Text"],
Cell[24626, 681, 451, 13, 121, "Input"],
Cell[25080, 696, 140, 3, 32, "Input"],
Cell[25223, 701, 65, 0, 46, "Text"],
Cell[25291, 703, 129, 2, 32, "Input"],
Cell[25423, 707, 108, 2, 32, "Input"],
Cell[25534, 711, 70, 0, 46, "Text"],
Cell[25607, 713, 118, 2, 32, "Input"]
}, Open  ]]
}
]
*)

